/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Interface definitions for gpfs kernel services, platform independent version
 *
 * Contents:
 *   vfs services:
 *
 * $Id: cxi2gpfs.h,v 1.72 2001/11/20 20:43:30 radhak Exp $
 *
 * $Log: cxi2gpfs.h,v $
 * Revision 1.72  2001/11/20 20:43:30  radhak
 * Defect 353917:
 * vm_ops->close() always be done after calling vm_ops->open() even if
 * returns error. Because of this Linux semantics we need to increment
 * mmap counters even if an error occurs.
 *
 * Revision 1.71  2001/09/29 02:00:38  manoj
 * Fix for Raleigh defect 6854: Ensure that stale pages in Linux's page cache
 * get invalidated on a BR token revoke in both the daemon and kernel versions
 * of flushMappedPages.
 *
 * Revision 1.70  2001/09/22 20:10:22  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.69  2001/09/20 21:49:53  wyllie
 * Fix compile error
 *
 * Revision 1.68  2001/09/10 04:33:37  manoj
 * Fix for Raleigh defect 5687 and others. "Path walks" in Windows don't require
 * execute permission on directory components like they do on Unix. Access
 * for file lookup only requires FILE_READ_DATA permission on the parent
 * directory.  File operations require FILE_READ_DATA on parent and desired
 * access on target. Directory operations require desired access on target and
 * no parent directory permissions. Allow path_walk access for Windows callers
 * and use gpfsCheckNTAccess (through nss_ntaccess) for specific NT permissions.
 *
 * Revision 1.67  2001/08/23 22:55:32  manoj
 * Define an interface to allow a machine SID to be registered for access control.
 *
 * Revision 1.66  2001/08/16 21:23:42  manoj
 * Pass openFile as an argument to breakSMBOplock to check for oplock 
 * status. Move SMB enums from ShHash.h to cxiTypes.h since they are also 
 * used by the portability code.
 *
 * Revision 1.65  2001/08/04 00:42:28  tee
 * Remove LINUX_MMAP ifdefs
 *
 * Revision 1.64  2001/07/19 23:25:22  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.63  2001/07/11 03:57:00  manoj
 * Define gpfsCheckNTAccess to check if NT caller has access to a file through
 * individual NT permission bits (other that standard rwx which can be checked by
 * access() call).
 *
 * Revision 1.62  2001/07/10 12:05:14  jpalmer
 * Add function to allow SMB Open and FCNTL tokens to be moved from one system to
 * another in response to the NAS load balancer moving the users.  Add the
 * external interface to provide a lock clamping function that will block new
 * locks during the time NFS is recovering its FCNTL and File locks.
 *
 * Revision 1.61  2001/06/19 17:44:13  eshel
 * Add gpfsSyncNFS to sync attributes for NFS setattr call.
 *
 * Revision 1.60  2001/05/12 18:38:32  schmuck
 * Fix problem with NFS returning spurious errors under load.
 *
 * Revision 1.59  2001/05/08 13:41:20  dixonbp
 * Add gpfsCleanup prototype and include it in gpfs_operations.
 *
 * Revision 1.58  2001/05/02 02:08:03  schmuck
 * Apply recent tortureDir test related fixes to gpfs_i_link:
 * Return from kSFSLink with an inode lock held; set the CO_VFS_REFERENCE
 * flag an instantiate the dcache entry before releasing the lock.
 *
 * Revision 1.57  2001/05/02 00:21:30  schmuck
 * Fix another problem found by tortureDir test on Linux:
 * On lookup and create, instantiate the dcache entry while holding the
 * inode lock, or, in case of a negative dcache entry, the directory lock.
 * This closes a window where a token revoke could clear the
 * CO_VFS_REFERENCE flag without invalidating the dcache entry.
 * It also eliminates the need for a d_revalidate operation.
 *
 * Revision 1.56  2001/04/29 21:52:35  schmuck
 * SMB_LOCKS code cleanup:
 * In-line openlock state updates on fast open/close path.
 * Remember whether an open (share-mode) lock was obtained;
 * if not, skip cleanup code in close.
 * Removed unused 'isSamba' flag in vinfo.
 *
 * Revision 1.55  2001/04/23 18:13:04  eshel
 * Call DaemonToDie to get internal dump.
 *
 * Revision 1.54  2001/04/08 22:18:42  dcraft
 * Fix multinde delete race conditions.  Still incomplete.
 *
 * Revision 1.53  2001/04/03 17:22:20  eshel
 * Add delete_inode() to mark inode for destruction when on last 
 * linux iput() call.
 *
 * Revision 1.52  2001/03/30 17:40:03  eshel
 * don't update atime on gpfs_iread (read by inode) call
 *
 * Revision 1.51  2001/03/30 10:19:37  manoj
 * Remove "extern C" from NSS declarations.
 *
 * Revision 1.50  2001/03/30 01:03:52  jpalmer
 * Remove unused parameter from SMBOpenLockControl
 *
 * Revision 1.49  2001/03/29 16:42:32  dixonbp
 * Preparations for converting files from .C to .c
 *
 * Revision 1.48  2001/03/28 08:50:17  manoj
 * Support for DOS attributes (NSS only). Define gpfs_ops GetDosAttr and
 * SetDosAttr for the purpose.
 *
 * Revision 1.47  2001/03/20 01:17:47  manoj
 * Added a new parameter to pass cred to gpfsGetAcl required to validate user
 * access for NT ACLs.
 *
 * Revision 1.46  2001/03/13 22:16:31  eshel
 * change interface to gpfsWrite()
 *
 * Revision 1.45  2001/03/12 01:56:52  jpalmer
 * SMB Locking: Default lock acquire/delete
 *
 * Revision 1.44  2001/03/09 18:10:53  schmuck
 * More SMB oplock code.
 *
 * Revision 1.43  2001/03/09 16:46:33  jpalmer
 * SMB Locking - remove old dfs Interops functions
 *
 * Revision 1.42  2001/03/09 02:28:31  schmuck
 * Changes for SMB oplocks.
 *
 * Revision 1.41  2001/03/08 16:12:10  jpalmer
 * SMB Locking - Detect smbd call, set isSamba in MMFSVinfo
 *
 * Revision 1.40  2001/03/02 22:43:52  jpalmer
 * SMB Locking function: user communications
 *
 * Revision 1.39  2001/02/27 01:16:13  eshel
 * add gpfs_ops.gpfsReady()
 *
 * Revision 1.38  2001/01/27 00:36:55  eshel
 * add code to support gpfs_iwritedir()
 *
 * Revision 1.37  2000/12/15 20:19:58  dcraft
 * Fix build break with mmapLock
 *
 * Revision 1.36  2000/12/15 13:57:05  gjertsen
 * Clean up documentation.
 *
 * Revision 1.35  2000/12/12 16:34:55  wyllie
 * Remove MemPool operations from gpfs_ops.
 *
 * Revision 1.34  2000/11/30 21:58:39  schmuck
 * Split gpfsReadWrite into gpfsRead and gpfsWrite
 *
 * Revision 1.33  2000/11/07 19:25:12  schmuck
 * Use same Linux-style filldir interface for readdir on Linux and aix.
 *
 * Revision 1.32  2000/10/31  15:42:30  gjertsen
 * Insert atomic operations into cxi layer.
 *
 * Revision 1.31  2000/10/30  20:49:06  radhak
 * -DLINUX_MMAP: Linux mmap support
 *
 * Revision 1.30  2000/10/23  20:04:26  dixonbp
 * Remove gpfsNodeP from NFSData and the GetNFS interface.
 *
 * Revision 1.29  2000/10/19  19:10:24  dixonbp
 * Prototypes for nfs/watchdog functions.
 *
 * Revision 1.28  2000/09/29  00:03:57  schmuck
 * Some more experimental code to speed up readdir.
 *
 * Revision 1.27  2000/09/13  14:38:16  dcraft
 * Implement tsstat/tsfstat for linux.  Split out syscall ioctl routines
 * into standalone library for binding with commands.  Build
 * tslsattr/tschattr commands.  Clean up some Imakefiles for linux.
 *
 * Revision 1.26  2000/09/07  21:34:56  dcraft
 * Make tsfattr/tsattr work on linux.  Make kxPutACL/kxGetACL
 * routines and ACL commands work on linux.  Split kx routines
 * into OS dependent directories.
 *
 * Revision 1.25  2000/08/29  20:15:22  curran
 * New Compiler: Remove default values from a couple of pointers in
 * the gpfs_operations table. default values only allowed on the actual function
 * declaration.
 *
 * Revision 1.24  2000/08/29  18:32:57  dcraft
 * Now produce mmfs module.
 *
 * Revision 1.23  2000/08/28  14:14:59  gjertsen
 * Use C wrapper functions for C++ class methods in
 * cxi interface. Convert all cxi functions to C interface.
 *
 * Revision 1.22  2000/08/07  22:33:27  dcraft
 * Use new cxiGetTOD() time of day function for second,
 * nanosecond needs.  Define 32 bit time types and start
 * using in place of current on disk time_t types (necessary
 * for 64 bit).  Use HiResTime where possible.
 *
 * Revision 1.21  2000/08/07  21:53:55  tee
 * Remove duplicate log line
 *
 * Revision 1.20  2000/08/07 21:46:25  tee
 * Put back three sets of revisions that were lost because of last checkin.
 *
 * Revision 1.19  2000/08/07 20:46:43  andreye
 * Added three new function pointers to the gpfs_operations struct.
 * PoolAlloc, PoolFree and PoolGetStatus
 *
 * Revision 1.18  2000/07/19 18:59:34  eshel
 * add support for sync
 *
 * Revision 1.17  2000/07/19  16:05:51  wyllie
 * Change kxi to cxi in #define symbol.
 *
 * Revision 1.16  2000/07/11  19:31:50  dcraft
 * gpfsNode_t::findOrCreate no longer creates an OS specific node on
 * linux.  This caused coding problems since gpfsNode release cannot call
 * iput() itself nor can it decrement the i_count.  The inode is gotten
 * at the vfs specific layer thereby guaranteeing that linux will be
 * responsible for the iput() and i_count decrement.
 *
 * Revision 1.15  2000/07/11  16:35:52  wyllie
 * Use cxiUio_t instead of struct uio.  Use cxiUiomove instead of uiomove.  Use
 * CXI_READ instead of UIO_READ, etc.
 *
 * Revision 1.14  2000/06/28  19:23:07  dcraft
 * Remove struct ucred and cred.h dependencies from all OS
 * independent code.  Consistently use cxiUid_t and cxiGid_t.
 * Add linux, aix directories to ts/fs for system dependent code.
 * No-op entry points to DFS export code to avoid ifdefs.
 *
 * Revision 1.13  2000/06/28  12:47:17  gjertsen
 * Now use eflock_t in platform independant code due to problem with
 * compiling struct eflock when eflock is already typedef'ed to a struct.
 *
 * Revision 1.12  2000/06/27  17:40:08  dixonbp
 * Return inodeP from gpfsMkdir gpfsSymlink, and gpfsMknod.
 *
 * Revision 1.11  2000/06/23  20:31:35  dcraft
 * Remove sysdep.h and ModeBits.h.  Pare down some OS specific
 * header includes.  Use cxiMode_t instead of mode_t due to
 * linux short mode_t in kernel.
 *
 * Revision 1.10  2000/06/16  20:32:55  dcraft
 * Split MMFSNode into cxiNode_t containing OS dependent items
 * (such as gnode) and gpfsNode_t OS independent items.  Acquire
 * inodes during creation of gpfsNodes.  Remove __FULL_PROTO and
 * system prototypes from all C files.  Turn on __FULL_PROTO in
 * site.mcr.
 *
 * Revision 1.9  2000/06/13  14:49:40  dixonbp
 * Add gpfsFcntlReset to gpfs_ops.
 *
 * Revision 1.8  2000/06/12  19:32:23  dcraft
 * Rename SharkPrivateVFSData to gpfsVFSData_t and split off into OS independent
 * vfsdata.h.   OS dependent layer relies only on forward declaration gpfsVFSData_t
 * since it uses it only as a pointer (hence the non cxi name).
 *
 * Revision 1.7  2000/06/08  21:31:22  dcraft
 * Make unmount OS independent.  Correct OS independent mount problems.
 *
 * Revision 1.6  2000/06/06  20:04:16  dixonbp
 * Add gpfsFcntl to gpfs_operations.
 *
 * Revision 1.5  2000/06/05  19:01:26  dcraft
 * Complete mount callbacks within the OS dependent kernel extension.
 * Record vfs number in gpfsVfsData_t.
 *
 * Revision 1.4  2000/05/30  23:43:12  eshel
 * more for the module split
 *
 * Revision 1.3  2000/05/30  19:04:57  dcraft
 * Initial drop of vfs ops (mount).  Feng Shui placement of new cxi types.
 *
 * Revision 1.2  2000/05/26  00:35:47  eshel
 * more on the way to splitting the kernel code
 *
 * Revision 1.1  2000/05/24  23:42:21  eshel
 * new file for interface definitions of gpfs kernel services
 *
 *
 */

#ifndef _h_cxi2gpfs
#define _h_cxi2gpfs

#ifdef _KERNEL

/* Describes the entry points into the OS independent portion of
 * GPFS from the dependent virtual file system layer.
 */
struct gpfsVfsData_t;
struct ext_cred_t;
struct MMFSVInfo;
struct cxiUio_t;
#ifdef SMB_LOCKS
struct SMBTokenDescription;
#endif

/* GPFS OS independent entry point prototypes */
int gpfsFsync(struct gpfsVfsData_t *, cxiNode_t *, int, struct ext_cred_t *);
int gpfsSyncNFS(struct gpfsVfsData_t *, cxiNode_t *, int, struct ext_cred_t *);
int gpfsMkdir(struct gpfsVfsData_t *, cxiNode_t *cnDirP,
              void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP,
              void *dentryP, caddr_t nameP, int, cxiMode_t mode,
              struct ext_cred_t *);
int gpfsLink(struct gpfsVfsData_t *, cxiNode_t *, cxiNode_t *,
             void *, char *, struct ext_cred_t *);
int gpfsOpen(struct gpfsVfsData_t *, cxiNode_t *, int, int,
             struct MMFSVInfo **, struct ext_cred_t *);
int gpfsInodeRead(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                  cxiIno_t ino, void *opaque);
int gpfsInodeDelete(struct gpfsVfsData_t *, cxiNode_t *, Boolean isGPFS,
                    struct ext_cred_t *);
int gpfsRemove(struct gpfsVfsData_t *, cxiNode_t *, cxiNode_t *,
               char *, struct ext_cred_t *);
int gpfsRename(struct gpfsVfsData_t *, cxiNode_t *, cxiNode_t *,
               caddr_t, cxiNode_t *, cxiNode_t *, caddr_t,
               struct ext_cred_t *);
int gpfsRmdir(struct gpfsVfsData_t *, cxiNode_t *, cxiNode_t *,
              char *, struct ext_cred_t *);
int gpfsSetattr(struct gpfsVfsData_t *, cxiNode_t *, long, long, long,
                long, struct ext_cred_t *);
int gpfsSymlink(struct gpfsVfsData_t *, cxiNode_t *dcnP, void **vPP,
                cxiNode_t **cnPP, cxiIno_t *iNumP, void *dentryP, caddr_t nameP,
                char *symlinkTargetP, struct ext_cred_t *);
int gpfsFsyncRange(struct gpfsVfsData_t *, cxiNode_t *, int, offset_t,
                   offset_t, struct ext_cred_t *);
int gpfsClose(struct gpfsVfsData_t *, cxiNode_t *, int,
              struct MMFSVInfo *, Boolean dmEvents);
int gpfsUnmap(struct gpfsVfsData_t *, cxiNode_t *, int);
int gpfsFattr(struct gpfsVfsData_t *, cxiNode_t *, struct MMFSVInfo *,
              int, int, void *, void *, struct ext_cred_t *);
int gpfsFclear(struct gpfsVfsData_t *, cxiNode_t *,
               int, offset_t, offset_t, struct MMFSVInfo *, struct ext_cred_t *);
int gpfsFtrunc(struct gpfsVfsData_t *, cxiNode_t *, int, offset_t,
               struct MMFSVInfo *, struct ext_cred_t *, Boolean dmEvents);
int gpfsRead(struct gpfsVfsData_t *, cxiNode_t *, int, struct cxiUio_t *,
             struct MMFSVInfo *, cxiVattr_t *, struct ext_cred_t *, int);
int gpfsWrite(struct gpfsVfsData_t *, cxiNode_t *, int, struct cxiUio_t *,
              struct MMFSVInfo *, cxiVattr_t *, struct ext_cred_t *, int);
int gpfsGetattr(struct gpfsVfsData_t *, cxiNode_t *, cxiVattr_t *, Boolean exactStat);
int gpfsAccess(struct gpfsVfsData_t *, cxiNode_t *, int, int,
               struct ext_cred_t *);
int gpfsReaddir(struct gpfsVfsData_t *, cxiNode_t *, void *, cxiFillDir_t,
                offset_t *, cxiContext_t);
int gpfsReadlink(struct gpfsVfsData_t *, cxiNode_t *, struct cxiUio_t *);
int gpfsCreate(struct gpfsVfsData_t *privVfsP, cxiNode_t *dcnP,
               void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP, int gen,
               int flags, void *dentryP, caddr_t nameP, cxiMode_t mode,
               cxiMode_t umask, caddr_t *infoPP, struct ext_cred_t *);
int gpfsMknod(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnDirP,
              void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP,
              void *dentryP, caddr_t nameP, cxiMode_t mode, cxiMode_t umask,
              cxiDev_t dev, struct ext_cred_t *credP);
int gpfsRele(struct gpfsVfsData_t *, cxiNode_t *,
             void *, cxiContext_t);
int gpfsLookup(struct gpfsVfsData_t *, void *dvP, cxiNode_t *cnDirP,
               void *dentryP, char *nameP,
               void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP, cxiVattr_t *,
               cxiMode_t *, struct ext_cred_t *);
int gpfsMount(void *, int, char *, char *, char *, struct gpfsVfsData_t **,
              cxiNode_t **, cxiIno_t *iNumP, struct gpfsVfsData_t *, pid_t,
              unsigned int mountId, Boolean, Boolean);
int gpfsStatfs(struct gpfsVfsData_t *, cxiStatfs_t *);
int gpfsSyncfs(struct gpfsVfsData_t *);

void gpfsUncache(struct gpfsVfsData_t *privVfsP);

int gpfsUnmount(struct gpfsVfsData_t *privVfsP, Boolean forced);
void gpfsFinishUnmount(struct gpfsVfsData_t *privVfsP);

int gpfsFcntl(void *vkopP,
              struct gpfsVfsData_t *privVfsP,
              void *vP,                // struct vnode* or NULL
              void *advObjP,           // struct gnode* or struct file*
              void *flP,               // NULL or struct file_lock*
              cxiNode_t *cnP,
              offset_t offset,
              eflock_t *lckdatP,
              int cmd,                 // F_SETLK, F_SETLKW, F_GETLK
              int(*retry_fcn)(),
              ulong *retry_idP,
              struct ext_cred_t *credP,
              Boolean tokenAcquireOnly);
int gpfsFcntlReset(void *advObjP, cxiPid_t mmfsd);

int gpfsGetAcl(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
               void *aclP, struct ext_cred_t *credP);
int gpfsPutAcl(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
               void *aclP, struct ext_cred_t *credP);

#ifdef CONFIG_NSS
int gpfsGetDosAttr(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, 
                   int flags, unsigned char *attrP, struct ext_cred_t *credP);
int gpfsPutDosAttr(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, 
                   int flags, unsigned char attrP, struct ext_cred_t *credP);
int gpfsCheckNTAccess(struct gpfsVfsData_t *privVfsP, 
                      cxiNode_t *pcnP, cxiNode_t *cnP,
                      UInt32 ntmask, struct ext_cred_t *credP);
int gpfsSetMachineSID(void *sid, struct ext_cred_t *credP);
#endif

int gpfsGetNFS(void *, struct MMFSVInfo **, int *);
int gpfsReleaseNFS(void *);
int gpfsReady();
int gpfsMmap(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, void *vP,
             struct ext_cred_t *credP, void *kopP, Boolean writeAccess,
             Boolean explicit_mmap);
int pagerKprocMainThread(void *iparms);

#ifdef SMB_LOCKS
int SMBOpenLockControl(int command, int lockmode,
                       int inode_n, struct MMFSVInfo * vinfoP,
                       struct gpfsVfsData_t *privVfsP);
int SMBOpenLockMove(int command, int lockmode, int nodenumber,
                       int inode_n, struct MMFSVInfo * vinfoP,
                       struct gpfsVfsData_t *privVfsP);
int SMBGetOplockState(void *fileArgP);
int gpfsSetSMBOplock(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                     struct MMFSVInfo *vinfoP, int accessWant,
                     int oplockWant, void *breakArgP,
                     int *oplockGrantedP);
int gpfsClampLocks(struct gpfsVfsData_t *privVfsP, void * sbP, Boolean clamp);
#endif  //SMB_LOCKS
int callDaemonToDie(char  *srcFileName, UInt32 srcLineNumber,
                    Int32 retCode, Int32 reasonCode, char  *dataStr,
                    char  *failingExpr);
int gpfsCleanup();
int gpfsSwapdSignal(Boolean term);


struct gpfs_operations
{
  int (*mmfs)(int cmd);
  int (*gpfsMount)(void *, int, char *, char *, char *, struct gpfsVfsData_t **,
                   cxiNode_t **, cxiIno_t *iNumP, struct gpfsVfsData_t *, pid_t,
                   unsigned int, Boolean, Boolean);
  int(*gpfsStatfs)(struct gpfsVfsData_t *, cxiStatfs_t *);
  int(*gpfsSyncfs)(struct gpfsVfsData_t *);
  int (*gpfsFsync)(struct gpfsVfsData_t *, cxiNode_t *, int,
                   struct ext_cred_t *credP);
  int (*gpfsSyncNFS)(struct gpfsVfsData_t *, cxiNode_t *, int,
                     struct ext_cred_t *credP);
  int (*gpfsMkdir)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnDirP,
                   void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP,
                   void *dentryP, char *dirNameP, int mode, cxiMode_t umask,
                   struct ext_cred_t *credP);
  int (*gpfsLink)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                  cxiNode_t *dcnP, void *dentryP, char *name,
                  struct ext_cred_t *credP);
  int (*gpfsOpen)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                  int flags, int ext, struct MMFSVInfo **infoPP,
                  struct ext_cred_t *credP);
  int (*gpfsInodeRead)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                       cxiIno_t ino, void *opaque);
  int (*gpfsInodeDelete)(struct gpfsVfsData_t *, cxiNode_t *, Boolean isGPFS,
                         struct ext_cred_t *);
  int (*gpfsRemove)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                    cxiNode_t *dcnP, char *nameP, struct ext_cred_t *credP);
  int (*gpfsRename)(struct gpfsVfsData_t *privVfsP, cxiNode_t *sourceCNP,
                    cxiNode_t *sourceDirCNP, caddr_t oldNameP,
                    cxiNode_t *targetCNP, cxiNode_t *targetDirCNP,
                    caddr_t newNameP, struct ext_cred_t *credP);
  int (*gpfsRmdir)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                   cxiNode_t *dcnP, char *nameP, struct ext_cred_t *credP);
  int (*gpfsSetattr)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                     long cmd, long arg1, long arg2, long arg3,
                     struct ext_cred_t *credP);
  int (*gpfsSymlink)(struct gpfsVfsData_t *privVfsP, cxiNode_t *dcnP, void **vPP,
                     cxiNode_t **cnPP, cxiIno_t *iNumP,
                     void *dentryP, caddr_t nameP,
                     char *symlinkTargetP, struct ext_cred_t *credP);
  int (*gpfsFsyncRange)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                        int flags, offset_t offset, offset_t length,
                        struct ext_cred_t *credP);
  int (*gpfsClose)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                   int flags, struct MMFSVInfo *vinfoP,
                   Boolean dmEvents);
  int (*gpfsUnmap)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                   int flag);
  int (*gpfsFattr)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                   struct MMFSVInfo *vinfoP, int rwflag, int command,
                   void *argP, void *rCodeP, struct ext_cred_t *credP);
  int (*gpfsFclear)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                    int flags, offset_t offset, offset_t len,
                    struct MMFSVInfo *vinfoP, struct ext_cred_t *credP);
  int (*gpfsFtrunc)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                    int flags, offset_t offset, struct MMFSVInfo *vinfoP,
                    struct ext_cred_t *credP, Boolean dmEvents);
  int (*gpfsRead)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
                  struct cxiUio_t* uioP, struct MMFSVInfo *vinfoP,
                  cxiVattr_t *vattrP, struct ext_cred_t *credP, int);
  int (*gpfsWrite)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
                   struct cxiUio_t* uioP, struct MMFSVInfo *vinfoP,
                   cxiVattr_t *vattrP, struct ext_cred_t *credP, int);
  int (*gpfsGetattr)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                     cxiVattr_t *vattrP, Boolean exactStat);
  int (*gpfsAccess)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                    int mode, int who, struct ext_cred_t *credP);
  int (*gpfsReaddir)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                     void *fillDirArgP, cxiFillDir_t fillDirP,
                     offset_t *offsetP, cxiContext_t opcontext);
  int (*gpfsReadlink)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                      struct cxiUio_t* uioP);
  int (*gpfsCreate)(struct gpfsVfsData_t *privVfsP, cxiNode_t *dcnP,
                    void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP, int gen,
                    int flags, void *dentryP, caddr_t nameP, cxiMode_t mode,
                    cxiMode_t umask, caddr_t *infoPP, struct ext_cred_t *credP);
  int (*gpfsMknod)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnDirP,
                   void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP,
                   void *dentryP, caddr_t nameP, cxiMode_t mode, cxiMode_t umask,
                   cxiDev_t dev, struct ext_cred_t *credP);
  int (*gpfsRele)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                  void *vP, cxiContext_t opContext);
  int (*gpfsLookup)(struct gpfsVfsData_t *privVfsP, void *dvP, cxiNode_t *dcnP,
                    void *dentryP, char *nameP,
                    void **vPP, cxiNode_t **cnPP, cxiIno_t *iNumP,
                    cxiVattr_t *vattrP, cxiMode_t *modeP, struct ext_cred_t *credP);
  int (*gpfsFcntl)(void *vkopP,
                   struct gpfsVfsData_t *privVfsP,
                   void *vP,                // struct vnode* or NULL
                   void *advObjP,           // struct gnode* or struct file*
                   void *flP,               // NULL or struct file_lock*
                   cxiNode_t *cnP,
                   offset_t offset,
                   eflock_t *lckdatP,
                   int cmd,                 // F_SETLK, F_SETLKW, F_GETLK
                   int(*retry_fcn)(),
                   ulong *retry_idP,
                   struct ext_cred_t *credP,
                   Boolean tokenAcquireOnly);
  int (*gpfsFcntlReset)(void *advObjP, cxiPid_t mmfsd);
  void (*gpfsUncache)(struct gpfsVfsData_t *privVfsP);
  int (*gpfsUnmount)(struct gpfsVfsData_t *privVfsP, Boolean forced);
  void (*gpfsFinishUnmount)(struct gpfsVfsData_t *privVfsP);

  int (*gpfsGetAcl)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
                    void *aclP, struct ext_cred_t *credP);
  int (*gpfsPutAcl)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
                    void *aclP, struct ext_cred_t *credP);
#ifdef CONFIG_NSS
  int (*gpfsGetDosAttr)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
                        unsigned char *attrP, struct ext_cred_t *credP);
  int (*gpfsPutDosAttr)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, int flags,
                        unsigned char attrP, struct ext_cred_t *credP);
  int (*gpfsCheckNTAccess)(struct gpfsVfsData_t *privVfsP, 
                           cxiNode_t *pcnP, cxiNode_t *cnP,
                           UInt32 ntmask, struct ext_cred_t *credP);
  int (*gpfsSetMachineSID)(void *sid, struct ext_cred_t *credP);
#endif

  int (*gpfsGetNFS)(void *vP, struct MMFSVInfo **vinfoPP, int *flagsP);
  int (*gpfsReleaseNFS)(void *vP);
  int (*gpfsReady)();
  int (*gpfsMmap)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP, void * vP,
                  struct ext_cred_t *credP, void *koP, Boolean writeAccess,
                  Boolean explicit_mmap);
  int (*pagerKprocMainThread)(void *parmsP);
#ifdef SMB_LOCKS
  int (*SMBOpenLockControl)(int command, int lockmode,
                            int inode_n, struct MMFSVInfo * vinfoP,
                            struct gpfsVfsData_t *privVfsP);
  int (*SMBOpenLockMove)(int command, int lockmode, int nodenumber,
                            int inode_n, struct MMFSVInfo * vinfoP,
                            struct gpfsVfsData_t *privVfsP);
  int (*SMBGetOplockState)(void *fileArgP);
  int (*gpfsSetSMBOplock)(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
                          struct MMFSVInfo *vinfoP, int accessWant,
                          int oplockWant, void *breakArgP,
                          int *oplockGrantedP);
  int (*gpfsClampLocks)(struct gpfsVfsData_t *privVfsP, void* sbP, Boolean clamp);
#endif
  int (*gpfsDaemonToDie)(char  *srcFileName, UInt32 srcLineNumber,
                         Int32 retCode, Int32 reasonCode, char  *dataStr,
                         char  *failingExpr);
  int (*gpfsCleanup)();
  int (*gpfsSwapdSignal)(Boolean term);
};
extern struct gpfs_operations gpfs_ops;

#endif  /* _KERNEL */

#endif  /* _h_cxi2gpfs */

